/*
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *  
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 *  
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *  
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 * 
 */
/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4,
maxerr: 50, node: true */
/*global */
module.exports = function (grunt) {
    "use strict";
    
    grunt.initConfig({
        clean: {
            dist: {
                src: [
                    'services/Compilers/node_modules/less/.idea',
                    'services/Compilers/node_modules/less/projectFilesBackup',
                    'services/Compilers/node_modules/less/test',
                    'services/Compilers/node_modules/node-sass/node_modules/*',
                    '!services/Compilers/node_modules/node-sass/node_modules/semver/**',
                    'services/Compilers/node_modules/node-sass/scripts',
                    'services/Compilers/node_modules/node-sass/src',
                    'services/Compilers/node_modules/node-sass/test',
                    'services/Linters/node_modules/htmlhint/src',
                    'services/Linters/node_modules/htmlhint/test',
                    'services/Linters/node_modules/htmlhint/node_modules',
                    'services/Linters/node_modules/htmlhint/.jshintrc',
                    'services/Linters/node_modules/htmlhint/.npmignore',
                    'services/Linters/node_modules/htmlhint/.travis.yml'
                ]
            }
        },
        copy: {
            dist: {
                src: [
                    '**/*',
                    '!node_modules/grunt/**',
                    '!node_modules/grunt-contrib-clean/**',
                    '!node_modules/grunt-contrib-copy/**',
                    '!test/**'
                ],
                dest: 'dist/',
                expand: true
            }
        }
    });
    
    grunt.loadNpmTasks('grunt-contrib-clean');
    grunt.loadNpmTasks('grunt-contrib-copy');
    
    // task setup
    grunt.registerTask('default', ['clean:dist', 'copy']);
};